/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.models.SecuritySeaBoatModel;
import net.geforcemods.securitycraft.models.SecuritySeaRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.vehicle.Boat;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;

public class SecuritySeaBoatRenderer
extends BoatRenderer {
    public SecuritySeaBoatRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, true);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        ExtensionInfo extensionInfo = Boat.Type.getExtensionInfo();
        int size = !extensionInfo.extended() ? Boat.Type.values().length : extensionInfo.vanillaCount();
        for (int i = 0; i < size; ++i) {
            Boat.Type type = Boat.Type.values()[i];
            mapBuilder.put((Object)type, (Object)Pair.of((Object)SecurityCraft.resLoc("textures/entity/security_sea_boat/" + type.getName() + ".png"), this.createBoatModel(ctx, type, true)));
        }
        this.boatResources = mapBuilder.build();
    }

    public ListModel<Boat> createBoatModel(EntityRendererProvider.Context ctx, Boat.Type type, boolean chestBoat) {
        ModelPart modelPart = ctx.bakeLayer(ModelLayers.createChestBoatModelName((Boat.Type)type));
        if (type == Boat.Type.BAMBOO) {
            return new SecuritySeaRaftModel(modelPart);
        }
        return new SecuritySeaBoatModel(modelPart);
    }
}

